#ifndef __STM8_SWI2C_H
#define __STM8_SWI2C_H

/* Software (bit bang) Master I2C library V1.5 by Michal Dudka

User "manual":
- swi2c_init() "Experimental and Confusing". It only set selected pins to Open drain output mode. Not implemented for all MCUs ! Modify for your MCU or simply initialize used GPIO in your own way.
- swi2c_recover() - try to release SDA from offending slave (if transmission interrupted in moment when slave can pull SDA low)
- Comments before each function describe it. 
- Timing (unprecise) based on blocking delay_us function. Use from delay.h or provide your own.

notes:
SLA+W = Slave Addres with Write Bit
SLA+R = Slave Addres with Read Bit
RST = Reset condition/event


editlist:
3.9.2023 - corrected "i" type to uint16_t
2.12.2023 - edited GPIO_SDA_CLOCK_INIT/GPIO_SCL_CLOCK_INIT macro system
 		- added STM32F042x6
 		- corrected return value swi2c_recover()
11.12.2023 - added STM32F103xB
		- corrected order of GPIO init in swi2c_init() [thansk F103 LL API for their bug]
7.3.2024 - added "|| defined(STM32F072xB)"
28.3.2024 - added "|| defined(STM32F051x8)"
9.4.2024 - added "|| defined(STM32G071xx)"
10.6.2025 - added swi2c_write_array(),swi2c_write_eemem(),swi2c_read_eemem(), swi2c_write_cmd()
23.9.2025 - added "|| defined(STM32G0B1xx)"


*/


#include "main.h"
#include "delay.h"

#define SWI2C_VERSION 15

// ---- USER EDIT SECTION ----
// select GPIOs
#define SCL_GPIO_PORTA
#define SCL_PIN LL_GPIO_PIN_4
#define SDA_GPIO_PORTA
#define SDA_PIN LL_GPIO_PIN_3

// coarse timing parameters (~us) - change if you need
#define SWI2C_START_STOP_TIME 4
#define SWI2C_SDA_SETUP_TIME 1
#define SWI2C_SDA_HOLD_TIME 1
#define SWI2C_SCL_HALFPERIOD_TIME 4
// timeouts
#define SWI2C_TIMEOUT 0xffff // maximum number of waiting cycles

// ---- NO EDIT SECTION ----

#define SCL_stat() LL_GPIO_IsInputPinSet(SCL_GPIO,SCL_PIN)
#define SDA_stat() LL_GPIO_IsInputPinSet(SDA_GPIO,SDA_PIN)

#define SCL_HIGH LL_GPIO_SetOutputPin(SCL_GPIO,SCL_PIN)
#define SCL_LOW LL_GPIO_ResetOutputPin(SCL_GPIO,SCL_PIN)
#define SDA_HIGH LL_GPIO_SetOutputPin(SDA_GPIO,SDA_PIN)
#define SDA_LOW LL_GPIO_ResetOutputPin(SDA_GPIO,SDA_PIN)

#define SWI2C_SS_TIME _delay_us(SWI2C_START_STOP_TIME)
#define SWI2C_SETUP_TIME _delay_us(SWI2C_SDA_SETUP_TIME)
#define SWI2C_HOLD_TIME _delay_us(SWI2C_SDA_HOLD_TIME)
#define SWI2C_SCL_HIGH_TIME _delay_us(SWI2C_SCL_HALFPERIOD_TIME)

// hnus velebnosti - ur�it� to jde mnohem elegantn�ji
#if defined(SCL_GPIO_PORTA)
#define SCL_GPIO GPIOA
#elif defined(SCL_GPIO_PORTB)
#define SCL_GPIO GPIOB
#elif defined(SCL_GPIO_PORTC)
#define SCL_GPIO GPIOC
#elif defined(SCL_GPIO_PORTD)
#define SCL_GPIO GPIOD
#elif defined(SCL_GPIO_PORTE)
#define SCL_GPIO GPIOE
#elif defined(SCL_GPIO_PORTF)
#define SCL_GPIO GPIOF
#else
#error "Unknown PORT in swi2c.h"
#endif

#if defined(SDA_GPIO_PORTA)
#define SDA_GPIO GPIOA
#elif defined(SDA_GPIO_PORTB)
#define SDA_GPIO GPIOB
#elif defined(SDA_GPIO_PORTC)
#define SDA_GPIO GPIOC
#elif defined(SDA_GPIO_PORTD)
#define SDA_GPIO GPIOD
#elif defined(SDA_GPIO_PORTE)
#define SDA_GPIO GPIOE
#elif defined(SDA_GPIO_PORTF)
#define SDA_GPIO GPIOF
#else
#error "Unknown PORT in swi2c.h"
#endif

// cel� tahle hromada maker m� za �kol jen jednu jedinou v�c - zapnout clock pro GPIO t�ch dvou pin� co jste zvolili na za��tku :D :D 
// proto�e se to na G0 d�l� jinak ne� na F0 a jinak ne� na F1... 

#if defined(STM32G030xx) || defined(STM32G031xx) || defined(STM32G071xx)  || defined(STM32G0B1xx)

	#if defined(SDA_GPIO_PORTA)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SDA_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SDA PORT in swi2c.h"
	#endif

	#if defined(SCL_GPIO_PORTA)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SCL_CLOCK_INIT LL_IOP_GRP1_EnableClock(LL_IOP_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SCL PORT in swi2c.h"
	#endif

#elif defined(STM32F042x6) || defined(STM32F072xB) || defined(STM32F051x8)
	#if defined(SDA_GPIO_PORTA)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SDA_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SDA PORT in swi2c.h"
	#endif

	#if defined(SCL_GPIO_PORTA)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SCL_CLOCK_INIT LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SCL PORT in swi2c.h"
	#endif

#elif defined(STM32F103xB)
	#if defined(SDA_GPIO_PORTA)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SDA_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SDA PORT in swi2c.h"
	#endif

	#if defined(SCL_GPIO_PORTA)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOA)
	#elif defined(SDA_GPIO_PORTB)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOB)
	#elif defined(SDA_GPIO_PORTC)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOC)
	#elif defined(SDA_GPIO_PORTD)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOD)
	#elif defined(SDA_GPIO_PORTE)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOE)
	#elif defined(SDA_GPIO_PORTF)
		#define GPIO_SCL_CLOCK_INIT LL_APB2_GRP1_EnableClock(LL_APB2_GRP1_PERIPH_GPIOF)
	#else
		#error "Unknown SCL PORT in swi2c.h"
	#endif

#else
	#error "Unknown MCU in swi2c.h"
#endif

// user functions
void swi2c_init(void); // init GPIOs as Open Drain outputs
uint8_t swi2c_test_slave(uint8_t slvaddr); // check if slave with selected adres is present on bus
uint8_t swi2c_write_buf(uint8_t slv_addr, uint8_t address, uint8_t* data, uint16_t num); // SLA+W - 1B(Address) - num*1B(data)
uint8_t swi2c_read_buf(uint8_t slv_addr, uint8_t address, uint8_t* data, uint16_t num); // SLA+W - 1B(Address) - RST - SLA+R + num*1B(data)
uint8_t swi2c_write_array(uint8_t slv_addr, uint8_t* data, uint16_t num); // SLA+W - num*1B(data)
uint8_t swi2c_write_eemem(uint8_t slv_addr, uint16_t address, uint8_t* data, uint16_t num); // SLA+W - 2B (address) - num*1B(data)
uint8_t swi2c_read_eemem(uint8_t slv_addr, uint16_t address, uint8_t* data, uint16_t num); // SLA+W - 2B (address) - RST - SLA+R + num*1B(data)
uint8_t swi2c_write_cmd(uint8_t slv_addr, uint8_t cmd); // SLA+W - 1B (cmd/data)
uint8_t swi2c_recover(void);

// private functions
uint8_t swi2c_writebit(uint8_t bit);
uint8_t swi2c_readbit(void);
uint8_t swi2c_START(void);
uint8_t swi2c_RESTART(void);
uint8_t swi2c_STOP(void);



#endif /* __STM8_SWI2C_H*/
