/*
st7036i.h
Created: 25.06.2025 14:12:15
Author: Michal Dudka
version: 1.1
 
  Need SWI2C version 1.5 or higher
 
  consumption while displaying "0123456789" about
  210uA @ 5V
 
  Pinout for RX2002A
  1 - VOUT (bottom left) - 1uF to GND, about +10V
  2 - CAP1N - floating capacitor negative
  3 - CAP1P - floating capacitor positive
  4 - VDD
  5 - VSS
  6 - SDA
  7 - SCL
  8 - RST (active LOW)
  connection: 1uF or more from VOUT to GND, 100n-4u7 between CAP1x pins
  
  Contrast settings can be selected from precalculated values (search for LCD_CONTRAST macro)
  detailed procedure is:
	"Contrast" settings can be calculated as
	(100*Vt)/VDD = (Contr+36)*RAB
	where Vt=4.62V (something between 4.6 and 4.9)
	VDD = LCD supply voltage
	RAB ratio between 1x to 3.75x (details below)
	0    1.00x
	1    1.25x
	2    1.50x
	3    1.80x
	4    2.00x
	5    2.50x
	6    3.00x
	7    3.75x
	Contr is value between 0 to 63
	some precalculated values are below macro LCD_CONTRAST  

	edit list:
	25.6.2025 - v.10 release
	14.10.2025 - added support for ST7036 and ST7032 (selected by macros USE_ST7036 and USE_ST7032). Drivers differ in slave address (ST7036 0x3C, ST7032 0x3E 7bit format, right aligned)
  
 */ 


#ifndef ST7036I_H_
#define ST7036I_H_

// select your driver (ST7036 for RX2002, ST7036 for RX1602)
// #define USE_ST7036
 #define USE_ST7032

#define LCD_BOOSTER_ON // uncomment to enable voltage doubler
#define LCD_RAB_VALUE 4 // 0=1x , 1=1.25x , 2=1.5x , 3=1.8x , 4=2x , 5=2.5x , 6=3x , 7=3.75x
#define LCD_CONTRAST 34 // 0..63
// VDD=5.0V -> booster off, RAB=1x, Contrast=56
// VDD=4.2V -> booster on , RAB=2x, Contrast=19
// VDD=4.0V -> booster on , RAB=2x, Contrast=26
// VDD=4.6V -> booster on , RAB=2x, Contrast=29
// VDD=3.3V -> booster on , RAB=2x, Contrast=34
// VDD=3.0V -> booster on , RAB=2x, Contrast=41
// VDD=2.7V -> booster on , RAB=2x, Contrast=49

//#define LCD_USE_DOUBLE_HEIGHT_FONT // uncomment to use "double height" font
#define LCD_LINES 2 // not implemented in init function yet - use 2-line
#define LCD_COLUMNS 16 // 8 , 12 , 16 , 20 , 40 (not all are properly implemented)


// private macros ----- do not edit (if you dont know what are you doing) ----
#ifdef LCD_USE_DOUBLE_HEIGHT_FONT
#define LCD_FUNC_SET_MASK 0x34 
#else
#define LCD_FUNC_SET_MASK 0x38
#endif

#define LCD_DISPLAY_CLEAR 										0b1<<0

#define LCD_RETURN_HOME 										0b1<<1

#define LCD_ENTRY_MODE_SET 										0b1<<2
#define LCD_DECREMENT										0b0<<1
#define LCD_INCREMENT										0b1<<1
#define LCD_ENTRY_W_SHIFT									0b1<<0
#define LCD_DISPLAY_NOSHIFT									0b0<<0

#define LCD_DISPLAY_ONOFF  										0b1<<3
#define LCD_ON												0b1<<2
#define LCD_OFF												0b0<<2
#define LCD_CURSOR_ON										0b1<<1
#define LCD_CURSOR_OFF										0b0<<1
#define LCD_BLINK_ON										0b1<<0
#define LCD_BLINK_OFF										0b0<<0

#define LCD_CURSOR_OR_DISPLAY_SHIFT								0b1<<4
#define LCD_DISPLAY_SHIFT									0b1<<3
#define LCD_CURSOR_SHIFT									0b0<<3
#define LCD_SHIFT_RIGHT										0b1<<2
#define LCD_SHIFT_LEFT										0b0<<2

#define LCD_FUNCTION_SET										0b1<<5
#define LCD_DOUBLE_LINE_FONT												0b1<<4
#define LCD_SINGLE_LINE_FONT												0b0<<4
#define LCD_2LINES												0b1<<3
#define LCD_1LINES												0b0<<3
#define LCD_FONT5X10											0b1<<2
#define LCD_FONT5X8											0b0<<2

#define LCD_SET_CGRAM											0b1<<6

#define LCD_SET_DDRAM											0b1<<7


#if defined(USE_ST7036)
#define ST703X_SLV_ADDR (0x3C<<1)
#endif

#if defined(USE_ST7032)
#define ST703X_SLV_ADDR (0x3E<<1)
#endif




#define lcd_delay_ms(D) HAL_Delay(D)

uint8_t lcd_init(void);
uint8_t lcd_puts(uint8_t *text);
uint8_t lcd_cmd(uint8_t cmd);
void lcd_gotoxy(uint8_t column, uint8_t line);		// set cursor at desired position

#define lcd_cursor_on() 	lcd_cmd(LCD_DISPLAY_ONOFF | LCD_ON | LCD_CURSOR_ON | LCD_BLINK_OFF) // activate underscore cursor
#define lcd_cursor_blink() 	lcd_cmd(LCD_DISPLAY_ONOFF | LCD_ON | LCD_CURSOR_OFF | LCD_BLINK_ON) // activate blinking block 5x8 cursor
#define lcd_cursor_off() 	lcd_cmd(LCD_DISPLAY_ONOFF | LCD_ON | LCD_CURSOR_OFF | LCD_BLINK_OFF) // deactivate both cursor (underscore and blink)
#define lcd_doubleline_on() lcd_cmd(LCD_FUNCTION_SET | LCD_DOUBLE_LINE_FONT)

#endif /* ST7036I_H_ */
