/*
 st7036i.c
 
 Created: 25.06.2025 14:12:33
 Author: Michal Dudka
 version: 1.0
 */ 

#include "main.h"
#include "delay.h"
#include <string.h>

#include "st703x.h"
#include "swi2c.h" // must be version 1.5 or higher

// check swi2c.h version
#ifndef SWI2C_VERSION
#warning "SWI2C library version was not specified (need version 1.5 or higher)"
#else
#if SWI2C_VERSION < 15
#error "Wrong SWI2C library (need version 1.5 or higher)"
#endif
#endif

#if defined(USE_ST7036) && defined(USE_ST7032)
#error "Select only one driver (ST7036 or ST7032)"
#elif !defined(USE_ST7036) && !defined(USE_ST7032)
#error "Driver not selected, uncomment/define USE_ST7036 or USE_ST7032"
#endif

// set cursor position
// column 0 to display length-1
// line 0 to display number_of_lines-1
void lcd_gotoxy(uint8_t column, uint8_t line){
	uint8_t tmp=0;

	#if LCD_LINES==4
	if(column > (LCD_COLUMNS-1)){column=LCD_COLUMNS-1;}
	if(line == 0){tmp=0x00;}
	else if(line==1){tmp = 0x40;}
	else if(line==2){tmp = 0x14;}
	else{tmp = 0x54;}
	tmp = tmp + column;
	#endif

	#if LCD_LINES==2
	if(column > (LCD_COLUMNS-1)){column=LCD_COLUMNS-1;}
	if(line == 0){tmp=0x00;}
	else if(line==1){tmp = 0x40;}
	tmp = tmp + column;
	#endif

	#if LCD_LINES==1
	if(column > (LCD_COLUMNS-1)){column=LCD_COLUMNS-1;}
	tmp = tmp + column;
	#endif

	lcd_cmd(LCD_SET_DDRAM | tmp);
}

// print string (typicaly from actual cursor position)
uint8_t lcd_puts(uint8_t *text) {
	uint8_t buffer[40];
	uint8_t len = (uint8_t)strlen(text);
	uint8_t index = 0, retval;
	if (text == NULL) return 3;
	if (len == 0) return 4;
	// Maxim�ln� d�lka textu (vstup max 32 znak� = 64 bajt� v�stup)
	if (len > 16) len = 16;

	for (uint8_t i = 0; i < len; ++i) {
		buffer[index++] = (i == len - 1) ? 0x40 : 0xC0; // posledn� = 0x40
		buffer[index++] = (uint8_t)text[i];
	}

	retval=swi2c_write_array(ST703X_SLV_ADDR, buffer,2*len);
	return retval;
}

// init sequence (use macros for contrast settings) 
uint8_t lcd_init(void){
	swi2c_init();
	lcd_delay_ms(40); // power-up delay
	lcd_cmd(LCD_FUNC_SET_MASK | 0b01); // Function Set: 8-bit, 1/2-line, IS=0, single/double height font + IS=1 (p�epnut� do Instruction Table 1)
	lcd_cmd(0x14);  // bias 1/5, non 3-line
	lcd_cmd(0x70 | (LCD_CONTRAST & 0x0F));     // Low nibble kontrastu (C3�C0)
	#ifdef LCD_BOOSTER_ON
		lcd_cmd(0x50 | ((LCD_CONTRAST >> 4) & 0x03) | 0b100); // High nibble kontrastu (C4, C5), booster on, ICON off
		//lcd_cmd(0x68 | 0b100);  // Follower control: internal follower ON, Rab = 2x
	#else
		lcd_cmd(0x50 | ((LCD_CONTRAST >> 4) & 0x03)); // High nibble kontrastu (C4, C5), booster off, ICON off
		//lcd_cmd(0x68 |0b000);  // Follower control: internal follower ON, Rab = 1.0x (irelevantn� bez boosteru)
	#endif
	lcd_cmd(0x68 | (LCD_RAB_VALUE & 0b111));  // Follower control: internal follower ON, set Rab
	lcd_cmd(LCD_FUNC_SET_MASK);  // Function Set: IS=0 (p�epnut� na Instruction Table 0 - norm�ln� p��kazy)
	lcd_cmd(0x0C);  // Display ON, cursor OFF, blink OFF
	lcd_cmd(0x01);  // Clear display
	lcd_delay_ms(2);
	lcd_cmd(0x06);  // Entry mode: cursor moves right, no shift
	return 0;
}

// general command (consult datasheet ST7036 to details)
uint8_t lcd_cmd(uint8_t cmd) {
	uint8_t retval, data[2];
	data[0]=cmd; // set display on, cursor on, blink on ?
	retval=swi2c_write_buf(ST703X_SLV_ADDR, 0x00, data,1);
	return retval;
}
