/*
 * delay.c
 *
 *  Created on: 18. 12. 2022
 *      Author: mdudk
 */

#include "main.h"
#include "delay.h"

/*
 * Coarse blocking "delay microsecond" function.
 * Need (free) running systick with period longer then any ISR routine
 * Jitter dominated by IRQ routines (for example systick routine)
 * Measured values for STM32G030 running 64MHz with 10us nominal delay
 * -Og 				11.9us (1us jitter)
 * -O1 				13.0us(2us jitter)
 * -O2 				10.2us (1us jitter)
 * -O3 				10.3us (0.2us jitter)
 * -Os 				11.7us (1us jitter)
 * -Ofast 	10.2us (0.2us jitter)
 */
void _delay_us(uint16_t Delay){
	int32_t delay_ticks = Delay*(SystemCoreClock/1000000UL);
	int32_t last = SysTick->VAL;
	int32_t elapsed = 0;
	while (elapsed < delay_ticks){
		int32_t now = SysTick->VAL;
		elapsed += (last - now);
		last = now;
		if(elapsed < 0) {
			elapsed += SysTick->LOAD;
		}
	}
}

